VERSION 5.00
Object = "{20DF8FE2-B226-11D3-ABFF-0040055DE809}#1.0#0"; "DATAQFILE.OCX"
Object = "{AEAA9C62-8C52-11D3-ABFF-0040055DE809}#1.0#0"; "DQCHART.OCX"
Begin VB.Form Form1 
   Caption         =   "Extract a channel from WinDaq file and convert it to .WAV file"
   ClientHeight    =   4140
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6705
   LinkTopic       =   "Form1"
   ScaleHeight     =   4140
   ScaleWidth      =   6705
   StartUpPosition =   3  'Windows Default
   Begin DQCHARTLib.DQChart DQChart1 
      Height          =   1335
      Left            =   240
      TabIndex        =   11
      Top             =   2520
      Width           =   6255
      _Version        =   65536
      _ExtentX        =   11033
      _ExtentY        =   2355
      _StockProps     =   0
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Always overwrite"
      Height          =   255
      Left            =   4320
      TabIndex        =   9
      Top             =   1080
      Value           =   1  'Checked
      Width           =   1695
   End
   Begin DATAQFILELib.ReadDataqFile ReadDataqFile1 
      Left            =   2640
      Top             =   960
      _Version        =   65536
      _ExtentX        =   1085
      _ExtentY        =   873
      _StockProps     =   0
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   1080
      TabIndex        =   6
      Text            =   "1"
      Top             =   1080
      Width           =   495
   End
   Begin VB.CommandButton Command1 
      Caption         =   ">> Convert >>"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   2520
      TabIndex        =   2
      Top             =   360
      Width           =   1455
   End
   Begin VB.TextBox Text2 
      Height          =   405
      Left            =   4320
      TabIndex        =   1
      Text            =   "c:\sample.wav"
      Top             =   480
      Width           =   2175
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   240
      TabIndex        =   0
      Text            =   "c:\sample.wdq"
      Top             =   480
      Width           =   1935
   End
   Begin VB.Frame Frame1 
      Caption         =   "Extracted Channel"
      Height          =   1695
      Left            =   120
      TabIndex        =   12
      Top             =   2280
      Width           =   6495
   End
   Begin VB.Label Label6 
      AutoSize        =   -1  'True
      Caption         =   "SampleRate:"
      Height          =   195
      Left            =   240
      TabIndex        =   10
      Top             =   1920
      Width           =   915
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Channel Count:"
      Height          =   195
      Left            =   240
      TabIndex        =   8
      Top             =   1560
      Width           =   1095
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Channel:"
      Height          =   195
      Left            =   240
      TabIndex        =   7
      Top             =   1080
      Width           =   630
   End
   Begin VB.Label Label3 
      Height          =   615
      Left            =   2640
      TabIndex        =   5
      Top             =   1560
      Width           =   3735
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Output Wave file"
      Height          =   195
      Left            =   4320
      TabIndex        =   4
      Top             =   120
      Width           =   1200
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Input WinDaq file"
      Height          =   195
      Left            =   240
      TabIndex        =   3
      Top             =   120
      Width           =   1230
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' If you like this program, make sure you visit
'
' http://www.monumental.com/rshorne/gramdl.html
'
' to try out their spectrum analyzer!

Dim RIFFHEADER As RIFF
Dim iData(20000) As Integer
    
Private Sub Command1_Click()

ReadDataqFile1.filename = Text1.Text
ReadDataqFile1.Open
Label5.Caption = "Channel Count: " & ReadDataqFile1.ChannelCount

If Len(Text2.Text) And Check1.Value = False Then
    Label3.Caption = "Error: File already exists"
    Exit Sub
End If

If ReadDataqFile1.ChannelCount > 78 Then
    Label3.Caption = "Error: The maximum number of channels is 78"
    Exit Sub
End If

If ReadDataqFile1.ChannelCount <= 0 Then
    Label3.Caption = "Error: Invalid WinDaq file"
    Exit Sub
End If

If ReadDataqFile1.SampleRate < 100 Then
    Label3.Caption = "Error: Sample rate too low"
    Exit Sub
End If

If ReadDataqFile1.SampleRate > 50000 Then
    Label3.Caption = "Error: Sample rate too high"
    Exit Sub
End If

If ReadDataqFile1.ChannelCount < Val(Text3.Text) Or Val(Text3.Text) < 1 Then
    Label3.Caption = "Error: The requested channel is not available in this WinDaq file"
    Exit Sub
End If

DQChart1.channel = Val(Text3.Text) - 1
DQChart1.Chart ReadDataqFile1.GetData(DQChart1.Xmax, FormatBinary)

ReadDataqFile1.MoveTo -DQChart1.Xmax, 0


Label6.Caption = "Sample Rate: " & Format$(ReadDataqFile1.SampleRate, "0.0")

RIFFHEADER.file_length_8 = ReadDataqFile1.TotalDataPoints + 36
RIFFHEADER.sample_rate = ReadDataqFile1.SampleRate
RIFFHEADER.byte_rate = RIFFHEADER.sample_rate * 2
RIFFHEADER.data_block_length = ReadDataqFile1.TotalDataPoints

Open Text2.Text For Binary As #1
Put #1, , RIFFHEADER

channel_index = Val(Text3.Text) - 1
For i = 0 To ReadDataqFile1.TotalDataPoints Step 256
    iRead = ReadDataqFile1.GetDataExB(iData(0), 256)
    For j = 0 To (iRead - 1) * ReadDataqFile1.ChannelCount Step ReadDataqFile1.ChannelCount
        Put #1, , iData(channel_index + j)
    Next
Next

Close #1

End Sub

Private Sub Form_Load()

RIFFHEADER.riff_tag = "RIFF"
RIFFHEADER.file_length_8 = 0   'need to modify
RIFFHEADER.wave_tag = "WAVE"
RIFFHEADER.fmt_tag = "fmt "
RIFFHEADER.fmt_length = 16
RIFFHEADER.format_type = 1
RIFFHEADER.channel = 1
RIFFHEADER.sample_rate = 44100 'need to modify
RIFFHEADER.byte_rate = RIFFHEADER.sample_rate * 2 'need to modify
RIFFHEADER.block_align = 2
RIFFHEADER.bits = 16
RIFFHEADER.data_tag = "data"
RIFFHEADER.data_block_length = 0 'need to modify

End Sub

Private Sub ReadDataqFile1_ControlError(ByVal Code As Long)
Label3.Caption = "Error reading WinDaq file!"
End Sub

Private Sub ReadDataqFile1_EndOfFile()
Label3.Caption = "Done!"
End Sub

Private Sub ReadDataqFile1_FileError(ByVal Code As Long)
Label3.Caption = "Error reading WinDaq file!"
End Sub
